import matplotlib.pyplot as plt; import numpy as np; from osgeo import gdal; import os
import xlsxwriter
from pandas import DataFrame

global hori_section_series; global longi_section_series
global end_map;global z; global time_series
global time_space_point; global er, dir_0,folder_group
import csv

def depo_rate(order,oned_location):
    parent_folder = ['0','5','10','20','40',
                     1250,2500,5000,20000,]
    theme_parent =  ['%','%','%','%','%',
                     'k','k','k','k',]
    folder = parent_folder[order]
    theme = theme_parent[order]
    subfolder = ['1','2','3','4','5','6',][0]

    #print(folder,subfolder)
    #os.chdir(r'O:/00_0Qs/'+ str(folder) + theme + '/' + subfolder + '/1backup_EL00/')
#    os.chdir(r'Q:/0_0.55Qs_pi/10%/1/1backup_EL00/')
    #os.chdir(r'Q:/00_0Qs/0%/2/1backup_EL00/')
    #os.chdir(r'O:/0_0.55Qs_pi/20%_pi/old_2_withchannel/1backup_EL00/')
    #os.chdir(r'F:/paper_revision/00_0Qs/equilibrium_8_runs/5\1backup_EL00/')
    os.chdir(r'Q:\01_KBmodeloutput\06_02/3runs/1/1backup_EL/')
    
    z=[];end_map=800;hori_section=[];hori_section_series=[]
    longi_section_series=[];time_space_point=[]
    time_series=np.ones((80,200))
    
    
    x_section=oned_location
    
    for i in range(1,801,2): 
        hori_section=gdal.Open('%s'%i+'.map').ReadAsArray()[x_section,:] + i*0
        hori_section_series.append(hori_section)
     
    x_list = np.arange(1,40000,100)  # space there are 40,000(cross valley distance)/200(grid size)=200 points
    y_list = np.arange(1,800,2)  #time
    
    x = np.arange(0,200)
    #print (np.shape(hori_section_series))        
    for time in np.arange(399):       
            for space in x: # space range is always 0~200, representing 0~40 kyr
                time_space_point=hori_section_series[time+1][space]-hori_section_series[time][space]
                z.append(time_space_point*10)
    for time in np.arange(399,400):
        for space in x:
            time_space_point=0
            z.append(time_space_point*10)            
    
    erosion=np.asarray(z).reshape(400,200)
    marker_size=2    
    eeeee = erosion.mean(axis=1)
    ee_100 = eeeee # if this is switched on, it means average depositional rate. Otherwise, switch it off.
    #ee_100 = erosion[:,oned_location] # this determines what is your y coordinate. if y =100, then it means 100 by 200 = 20 km 

    # Create a workbook and add a worksheet.
    #os.mkdir(r'P:/paper_revision/depositional_rate_shortwavelength/excel_data/' )

    os.chdir(r'O:/')
    if not os.path.exists(str(oned_location)):
        os.makedirs(str(oned_location))
    os.chdir(r'O:/'+str(oned_location) +'/' )    
    workbook = xlsxwriter.Workbook(str(folder) + theme + '_'+subfolder+ '_'+str(oned_location) + '.xlsx')
    worksheet = workbook.add_worksheet()
    # Some data we want to write to the worksheet.
    expenses = (np.arange(len(ee_100 )),ee_100)
    
    # Start from the first cell. Rows and columns are zero indexed.
    row = 0
    col = 0
    # Write a total using a formula.
    #worksheet.write(row, 0, folder)
    
    # Iterate over the data and write it out row by row.
    for i in np.arange(len(ee_100)):        
        worksheet.write(row, col,ee_100[i])
        row += 1    
    workbook.close()  
    
    
    
    
    fig,ax = plt.subplots(figsize=(6,5))
    plt.plot(ee_100,color='k',)
    plt.xlim(0,400)
    plt.ylim(-1,8)
    #plt.ylim(-1,15) # for single location
    
    plt.xticks((0,100,200,300,400), ('0', '10', '20','30','40'), rotation=0,fontsize=20)
    plt.yticks([0,4,8], rotation=0,fontsize=20) # FOR equilibrium scenario
    plt.axhline(y=0,linestyle='--',color='k',linewidth=2,zorder=3)
    plt.ylabel('depo. rate (m/kyr)',fontsize=20)
    plt.xlabel('time (kyr)',fontsize=20)
    ax.fill_between(np.arange(0,400),ee_100,0,color='red',alpha=0.75,zorder=1,where = ee_100 <= 0)
    ax.fill_between(np.arange(0,400),ee_100,0,color='yellow',alpha=0.75,zorder=2,where = ee_100 > 0)
    plt.title(str(folder) + theme + subfolder + '_' + str(x_section) + '_1D_' + str(oned_location))
     
    my_file= str(folder) + theme + subfolder + str(x_section) + '_1D_' + str(oned_location)
    my_path = r'O:/'   
    os.makedirs(my_path, exist_ok=True)
    fig.savefig(os.path.join(my_path,my_file+'_eps'),bbox_inches='tight',dpi=999,format='eps')
    fig.savefig(os.path.join(my_path,my_file+'_2'),bbox_inches='tight',dpi=999)     
    #plt.show()        
#    os.chdir(r'O:/')
#    with open('eroison rate_4.csv', 'w', newline='') as file:
#        writer = csv.writer(file)
#        writer.writerows(ee_100)

#for i in [50,100,150,200,250]:
#    depo_rate(1,i)

depo_rate(5,100)